import { Repository } from 'typeorm';
import { Customer } from '../../entities/customer.entity';
import { CreateCustomerDto, UpdateCustomerDto, CustomerResponseDto } from './dto';
export declare class CustomerService {
    private readonly customerRepo;
    constructor(customerRepo: Repository<Customer>);
    private toCustomerResponseDto;
    create(dto: CreateCustomerDto): Promise<CustomerResponseDto>;
    findAll(): Promise<CustomerResponseDto[]>;
    findOne(id: string): Promise<CustomerResponseDto>;
    findByEmail(email: string): Promise<CustomerResponseDto>;
    findEntityByEmail(email: string): Promise<Customer | null>;
    update(id: string, dto: UpdateCustomerDto): Promise<CustomerResponseDto>;
    remove(id: string): Promise<void>;
    getProfile(customerId: string): Promise<CustomerResponseDto>;
    updateProfile(customerId: string, dto: UpdateCustomerDto): Promise<CustomerResponseDto>;
    findByPhone(phone: string): Promise<CustomerResponseDto>;
}
